/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Mcu.c
  \brief    	This file Initialize Mcu resources to emulate Pwm signals.   \n
                Pll setting is handle in this file.
  \author   	Freescale Semiconductor
  \author       r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version      0.1
  \date     	4/17/2008 11:31:45 AM
  \warning      Any modification to PLL settings will MODIFY the base interrupt \n
                frequency of the PIT module. 
  
  * History:
  
*/
/****************************************************************************************/
#include "Mcu.h"


/**
 * \brief     Configure and Inititlize PLL module.
 * \author    R01160
 * \param     
 * \return    none
 * \todo
 * \warning   Any modification to system clock frequency WILL modify the \n
              interrupt frequency of the PIT module giving as a result a \n
              mofification of the Pwm frequency signals.
 */  
 void vfnInit_PLL(void)
 {
    SIU.PCR[70].R = 0x060C;           /* Assign pad PortE[6] as CLKOUT signal */
    
    CRP_CLKSRC_XOSCEN   = 1;           /* Enable external oscillator            */
    SIU_ECCR_EBDF       = 3;           /* Divide sysclk by 3+1 for CLKOUT       */
    FMPLL_ESYNCR2       = 0x00000007;  /* Set ERFD to initial value of 8        */
    FMPLL_ESYNCR1       = 0xF0000020;  /* Set CLKCFG=PLL, EPREDIV=0, EMFD=0x20  */
    while (FMPLL_SYNSR_LOCK != 1) {};  /* Wait for PLL to LOCK                  */
    FMPLL_ESYNCR2       = 0x00000005;  /* Set ERFD to final value for 64 MHz sysclk */
    SIU_SYSCLK_SYSCLKSEL = 2;          /* Select PLL for sysclk                 */

 }